"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStarted = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _searchApiPanels = require("@kbn/search-api-panels");
var _constants = require("../../../../common/constants");
var _client_libraries = require("../../../assets/client_libraries");
var _doc_links = require("../doc_links");
var _http = require("../http");
var _curl = require("./languages/curl");
var _languages = require("./languages/languages");
var _add_data_panel_content = require("./panels/add_data_panel_content");
var _api_key_panel_content = require("./panels/api_key_panel_content");
var _initialize_client_panel_content = require("./panels/initialize_client_panel_content");
var _pipeline_panel = require("./panels/pipeline_panel");
var _search_query_panel_content = require("./panels/search_query_panel_content");
var _test_connection_panel_content = require("./panels/test_connection_panel_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GettingStarted = ({
  apiKeys,
  codeArgs,
  isPanelLeft = false,
  openApiKeyModal,
  showPipelinesPanel
}) => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    services
  } = (0, _public.useKibana)();
  const assetBasePath = http.basePath.prepend(`/plugins/${_constants.PLUGIN_ID}/assets/client_libraries`);
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(_curl.curlDefinition);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_searchApiPanels.SelectClientPanel, {
    docLinks: {
      elasticsearchClients: _doc_links.docLinks.clientsGuide,
      kibanaRunApiInConsole: _doc_links.docLinks.consoleGuide
    },
    isPanelLeft: isPanelLeft,
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    },
    application: services.application,
    sharePlugin: services.share,
    consolePlugin: services.console
  }, _languages.languageDefinitions.map((language, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `panelItem.${index}`
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.LanguageClientPanel, {
    language: language,
    setSelectedLanguage: setSelectedLanguage,
    isSelectedLanguage: selectedLanguage === language,
    src: _client_libraries.icons[language.id]
  })))), /*#__PURE__*/_react.default.createElement(_searchApiPanels.InstallClientPanel, {
    codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'installClient', codeArgs),
    consoleRequest: (0, _searchApiPanels.getConsoleRequest)('installClient'),
    languages: _languages.languageDefinitions,
    language: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage,
    assetBasePath: assetBasePath,
    application: services.application,
    sharePlugin: services.share,
    isPanelLeft: isPanelLeft,
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.gettingStarted.generateApiKeyPanel.description', {
      defaultMessage: "You'll need your private API key to securely connect to your project. Copy it somewhere safe."
    }),
    leftPanelContent: isPanelLeft ? /*#__PURE__*/_react.default.createElement(_api_key_panel_content.ApiKeyPanelContent, {
      apiKeys: apiKeys,
      openApiKeyModal: openApiKeyModal
    }) : undefined,
    rightPanelContent: isPanelLeft ? undefined : /*#__PURE__*/_react.default.createElement(_api_key_panel_content.ApiKeyPanelContent, {
      apiKeys: apiKeys,
      openApiKeyModal: openApiKeyModal
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.gettingStarted.generateApiKeyPanel.panelTitle', {
      defaultMessage: 'Generate an API key'
    }),
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CloudDetailsPanel, {
    cloudId: codeArgs.cloudId,
    elasticsearchUrl: codeArgs.url,
    isPanelLeft: isPanelLeft,
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.configureClient.description', {
      defaultMessage: 'Initialize your client with your unique API key'
    }),
    leftPanelContent: isPanelLeft ? /*#__PURE__*/_react.default.createElement(_initialize_client_panel_content.InitializeClientPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }) : undefined,
    rightPanelContent: isPanelLeft ? undefined : /*#__PURE__*/_react.default.createElement(_initialize_client_panel_content.InitializeClientPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.configureClient.title', {
      defaultMessage: 'Configure your client'
    }),
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.testConnection.description', {
      defaultMessage: 'Send a test request to confirm your language client and Elasticsearch instance are up and running.'
    }),
    leftPanelContent: isPanelLeft ? /*#__PURE__*/_react.default.createElement(_test_connection_panel_content.TestConnectionPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }) : undefined,
    rightPanelContent: isPanelLeft ? undefined : /*#__PURE__*/_react.default.createElement(_test_connection_panel_content.TestConnectionPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.testConnection.title', {
      defaultMessage: 'Test your connection'
    }),
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.ingestData.description', {
      defaultMessage: 'Add data to your data stream or index to make it searchable'
    }),
    leftPanelContent: isPanelLeft ? /*#__PURE__*/_react.default.createElement(_add_data_panel_content.AddDataPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }) : undefined,
    rightPanelContent: isPanelLeft ? undefined : /*#__PURE__*/_react.default.createElement(_add_data_panel_content.AddDataPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.ingestData.title', {
      defaultMessage: 'Ingest Data'
    }),
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.searchQuery.description', {
      defaultMessage: "Now you're ready to start experimenting with searching and performing aggregations on your Elasticsearch data."
    }),
    leftPanelContent: isPanelLeft ? /*#__PURE__*/_react.default.createElement(_search_query_panel_content.SearchQueryPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }) : undefined,
    rightPanelContent: isPanelLeft ? undefined : /*#__PURE__*/_react.default.createElement(_search_query_panel_content.SearchQueryPanelContent, {
      assetBasePath: assetBasePath,
      codeArgs: codeArgs,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.gettingStarted.searchQuery.title', {
      defaultMessage: 'Build your first search query'
    }),
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    }
  }), showPipelinesPanel && /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.gettingStarted.pipeline.description",
      defaultMessage: "Use {ingestPipelinesLink} to preprocess your data before it's indexed into Elasticsearch, which is often much easier than post-processing. Use any combination of ingest processors to add, delete, or transform fields in your documents.",
      values: {
        ingestPipelinesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "enterpriseSearchElasticsearchOverviewIngestPipelinesLink",
          href: _doc_links.docLinks.ingestPipelines,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.gettingStarted.description.ingestPipelinesLink.link', {
          defaultMessage: 'ingest pipelines'
        }))
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      size: "s",
      href: http.basePath.prepend('/app/management/ingest/ingest_pipelines/create'),
      "data-telemetry-id": "entSearch-gettingStarted-createPipeline",
      "data-test-subj": "create-a-pipeline-button"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.gettingStarted.pipeline.description.createButtonLabel', {
      defaultMessage: 'Create a pipeline'
    })))),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_pipeline_panel.GettingStartedPipelinePanel, null),
    links: [],
    overviewPanelProps: {
      color: 'plain',
      hasShadow: false
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.pipeline.title', {
      defaultMessage: 'Transform and enrich your data'
    })
  }));
};
exports.GettingStarted = GettingStarted;