"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _product_card = require("../product_card");
var _app_search_product_card = require("./app_search_product_card");
var _workplace_search_product_card = require("./workplace_search_product_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchProductCard = ({
  hasAppSearchAccess,
  hasWorkplaceSearchAccess,
  isWorkplaceSearchAdmin
}) => {
  const rightPanelItems = [];
  if (hasAppSearchAccess) {
    rightPanelItems.push( /*#__PURE__*/_react.default.createElement(_app_search_product_card.AppSearchProductCard, {
      hasBorder: false,
      hasShadow: false
    }));
  }
  if (hasWorkplaceSearchAccess) {
    rightPanelItems.push( /*#__PURE__*/_react.default.createElement(_workplace_search_product_card.WorkplaceSearchProductCard, {
      isWorkplaceSearchAdmin: isWorkplaceSearchAdmin,
      hasBorder: false,
      hasShadow: false
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.entSearch.productCardDescription', {
      defaultMessage: 'Standalone applications tailored to simpler, user-friendly and business-focused search experiences.'
    }),
    emptyCta: true,
    cta: _i18n.i18n.translate('xpack.enterpriseSearch.enterpriseSearchCard.cta', {
      defaultMessage: 'Learn more'
    }),
    url: _doc_links.docLinks.start,
    icon: "logoEnterpriseSearch",
    name: _constants.ENTERPRISE_SEARCH_PRODUCT_NAME,
    productId: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.ID,
    rightPanelItems: rightPanelItems
  });
};
exports.EnterpriseSearchProductCard = EnterpriseSearchProductCard;