"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppSearchProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _product_card = require("../product_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppSearchProductCard = ({
  hasBorder = true,
  hasShadow = true
}) => /*#__PURE__*/_react.default.createElement(_product_card.ProductCard, {
  hasBorder: hasBorder,
  hasShadow: hasShadow,
  description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.productCardDescription', {
    defaultMessage: 'A bespoke solution for apps and websites, providing the tools you need to design, implement, and effectively manage those user-facing search experiences.'
  }),
  emptyCta: true,
  cta: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.cta', {
    defaultMessage: 'Explore'
  }),
  icon: "logoAppSearch",
  name: _constants.APP_SEARCH_PLUGIN.NAME,
  productId: _constants.APP_SEARCH_PLUGIN.ID,
  url: _constants.APP_SEARCH_PLUGIN.URL
});
exports.AppSearchProductCard = AppSearchProductCard;