"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ingestionStatusToColor = ingestionStatusToColor;
exports.ingestionStatusToText = ingestionStatusToText;
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ingestionStatusToText(ingestionStatus) {
  if (ingestionStatus === _searchConnectors.IngestionStatus.CONNECTED) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.connected.label', {
      defaultMessage: 'Connected'
    });
  }
  if (ingestionStatus === _searchConnectors.IngestionStatus.ERROR) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.connectorError.label', {
      defaultMessage: 'Connector failure'
    });
  }
  if (ingestionStatus === _searchConnectors.IngestionStatus.SYNC_ERROR) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.syncError.label', {
      defaultMessage: 'Sync failure'
    });
  }
  if (ingestionStatus === _searchConnectors.IngestionStatus.CONFIGURED) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.configured.label', {
      defaultMessage: 'Configured'
    });
  }
  return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.incomplete.label', {
    defaultMessage: 'Incomplete'
  });
}
function ingestionStatusToColor(ingestionStatus) {
  if (ingestionStatus === _searchConnectors.IngestionStatus.CONNECTED) {
    return 'success';
  }
  if (ingestionStatus === _searchConnectors.IngestionStatus.ERROR || ingestionStatus === _searchConnectors.IngestionStatus.SYNC_ERROR) {
    return 'danger';
  }
  return 'warning';
}