"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewPipeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ml_inference_logic = require("./ml_inference_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReviewPipeline = () => {
  const {
    mlInferencePipeline
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.review.title', {
    defaultMessage: 'Review your pipeline configuration'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.review.description', {
    defaultMessage: "This pipeline will be created and injected as a processor into your default pipeline for this index. You'll be able to use this new pipeline independently as well."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: "400px"
  }, JSON.stringify(mlInferencePipeline !== null && mlInferencePipeline !== void 0 ? mlInferencePipeline : {}, null, 2)))));
};
exports.ReviewPipeline = ReviewPipeline;