"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineHorizontalSteps = exports.AddInferencePipelineFooter = exports.AddInferencePipelineFlyout = exports.AddInferencePipelineContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _index_name_logic = require("../../index_name_logic");
var _index_view_logic = require("../../index_view_logic");
var _configure_fields = require("./configure_fields");
var _configure_pipeline = require("./configure_pipeline");
var _ml_inference_logic = require("./ml_inference_logic");
var _review_pipeline = require("./review_pipeline");
var _test_pipeline = require("./test_pipeline");
var _types = require("./types");
require("./add_inference_pipeline_flyout.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddInferencePipelineFlyout = props => {
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    setIndexName,
    makeMlInferencePipelinesRequest,
    startPollingModels,
    makeMappingRequest
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  (0, _react.useEffect)(() => {
    setIndexName(indexName);

    // Trigger fetching of initial data: existing ML pipelines, available models, index mapping
    makeMlInferencePipelinesRequest(undefined);
    startPollingModels();
    makeMappingRequest({
      indexName
    });
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: props.onClose,
    className: "enterpriseSearchInferencePipelineFlyout",
    size: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.title', {
    defaultMessage: 'Add an inference pipeline'
  })))), /*#__PURE__*/_react.default.createElement(AddInferencePipelineContent, props));
};
exports.AddInferencePipelineFlyout = AddInferencePipelineFlyout;
const AddInferencePipelineContent = ({
  onClose
}) => {
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    createErrors,
    isLoading,
    addInferencePipelineModal: {
      step
    }
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);

  // Using the value of create errors to reduce unnecessary hook calls
  const createErrorsHookDep = createErrors.join('|');
  (0, _react.useEffect)(() => {
    if (createErrors.length === 0) return;
    const flyoutOverflow = document.getElementsByClassName('euiFlyoutBody__overflow');
    if (flyoutOverflow.length === 0) return;
    flyoutOverflow[0].scrollTop = 0;
  }, [createErrorsHookDep]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, createErrors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.createErrors', {
      defaultMessage: 'Error creating pipeline'
    }),
    color: "danger",
    iconType: "error"
  }, createErrors.map((message, i) => /*#__PURE__*/_react.default.createElement("p", {
    key: `createError.${i}`
  }, message))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(AddInferencePipelineHorizontalSteps, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), step === _types.AddInferencePipelineSteps.Configuration && /*#__PURE__*/_react.default.createElement(_configure_pipeline.ConfigurePipeline, null), step === _types.AddInferencePipelineSteps.Fields && /*#__PURE__*/_react.default.createElement(_configure_fields.ConfigureFields, null), step === _types.AddInferencePipelineSteps.Test && /*#__PURE__*/_react.default.createElement(_test_pipeline.TestPipeline, null), step === _types.AddInferencePipelineSteps.Review && /*#__PURE__*/_react.default.createElement(_review_pipeline.ReviewPipeline, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "enterpriseSearchInferencePipelineFlyoutFooter"
  }, /*#__PURE__*/_react.default.createElement(AddInferencePipelineFooter, {
    onClose: onClose,
    ingestionMethod: ingestionMethod
  })));
};
exports.AddInferencePipelineContent = AddInferencePipelineContent;
const AddInferencePipelineHorizontalSteps = () => {
  const {
    addInferencePipelineModal: {
      step
    },
    isConfigureStepValid,
    isPipelineDataValid
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    onAddInferencePipelineStepChange
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);

  /**
   * Convenience function for determining the status of a step in the horizontal nav.
   * @param currentStep The current step in the pipeline.
   * @param otherStep The step to compare against.
   * @returns The status of the step.
   */
  const getStepStatus = (currentStep, otherStep) => currentStep > otherStep ? 'complete' : currentStep === otherStep ? 'current' : 'incomplete';
  const navSteps = [{
    // Configure
    onClick: () => onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Configuration),
    status: step > _types.AddInferencePipelineSteps.Configuration ? 'complete' : 'current',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.configure.title', {
      defaultMessage: 'Configure'
    })
  }, {
    // Fields
    onClick: () => {
      if (!isConfigureStepValid) return;
      onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Fields);
    },
    status: isConfigureStepValid ? getStepStatus(step, _types.AddInferencePipelineSteps.Fields) : 'disabled',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.fields.title', {
      defaultMessage: 'Fields'
    })
  }, {
    // Test
    onClick: () => {
      if (!isPipelineDataValid) return;
      onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Test);
    },
    status: isPipelineDataValid ? getStepStatus(step, _types.AddInferencePipelineSteps.Test) : 'disabled',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.test.title', {
      defaultMessage: 'Test (Optional)'
    })
  }, {
    // Review
    onClick: () => {
      if (!isPipelineDataValid) return;
      onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Review);
    },
    status: isPipelineDataValid ? getStepStatus(step, _types.AddInferencePipelineSteps.Review) : 'disabled',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.review.title', {
      defaultMessage: 'Review'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: navSteps
  });
};
exports.AddInferencePipelineHorizontalSteps = AddInferencePipelineHorizontalSteps;
const AddInferencePipelineFooter = ({
  ingestionMethod,
  onClose
}) => {
  const {
    addInferencePipelineModal: modal,
    isPipelineDataValid,
    isConfigureStepValid
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    attachPipeline,
    createPipeline,
    onAddInferencePipelineStepChange
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const attachExistingPipeline = Boolean(modal.configuration.existingPipeline);
  let nextStep;
  let previousStep;
  let isContinueButtonEnabled = false;
  switch (modal.step) {
    case _types.AddInferencePipelineSteps.Configuration:
      nextStep = _types.AddInferencePipelineSteps.Fields;
      isContinueButtonEnabled = isConfigureStepValid;
      break;
    case _types.AddInferencePipelineSteps.Fields:
      nextStep = _types.AddInferencePipelineSteps.Test;
      previousStep = _types.AddInferencePipelineSteps.Configuration;
      isContinueButtonEnabled = isPipelineDataValid;
      break;
    case _types.AddInferencePipelineSteps.Test:
      nextStep = _types.AddInferencePipelineSteps.Review;
      previousStep = _types.AddInferencePipelineSteps.Fields;
      isContinueButtonEnabled = true;
      break;
    case _types.AddInferencePipelineSteps.Review:
      previousStep = _types.AddInferencePipelineSteps.Test;
      isContinueButtonEnabled = true;
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-cancel`,
    onClick: onClose
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, previousStep !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    iconType: "arrowLeft",
    onClick: () => onAddInferencePipelineStepChange(previousStep)
  }, _constants.BACK_BUTTON_LABEL) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, nextStep !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-continue`,
    iconType: "arrowRight",
    iconSide: "right",
    onClick: () => onAddInferencePipelineStepChange(nextStep),
    disabled: !isContinueButtonEnabled,
    fill: true
  }, _constants.CONTINUE_BUTTON_LABEL) : attachExistingPipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-attach`,
    disabled: !isContinueButtonEnabled,
    fill: true,
    onClick: attachPipeline
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.footer.attach', {
    defaultMessage: 'Attach'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-create`,
    disabled: !isContinueButtonEnabled,
    fill: true,
    onClick: createPipeline
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.footer.create', {
    defaultMessage: 'Create pipeline'
  }))));
};
exports.AddInferencePipelineFooter = AddInferencePipelineFooter;