"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDomainModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _delete_crawler_domain_api_logic = require("../../../../api/crawler/delete_crawler_domain_api_logic");
var _delete_domain_modal_logic = require("./delete_domain_modal_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteDomainModal = () => {
  _delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic.mount();
  const {
    deleteDomain,
    hideModal
  } = (0, _kea.useActions)(_delete_domain_modal_logic.DeleteDomainModalLogic);
  const {
    domain,
    isLoading,
    isHidden
  } = (0, _kea.useValues)(_delete_domain_modal_logic.DeleteDomainModalLogic);
  if (isHidden) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: hideModal,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deleteDomainModal.title', {
      defaultMessage: 'Delete domain'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deleteDomainModal.title', {
    defaultMessage: 'Delete domain'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.crawler.deleteDomainModal.description",
    defaultMessage: "Remove the domain {domainUrl} from your crawler. This will also delete all entry points and crawl rules you have set up. Any documents related to this domain will be removed on the next crawl. {thisCannotBeUndoneMessage}",
    values: {
      domainUrl: /*#__PURE__*/_react.default.createElement("strong", null, domain === null || domain === void 0 ? void 0 : domain.url),
      thisCannotBeUndoneMessage: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deleteDomainModal.thisCannotBeUndoneMessage', {
        defaultMessage: 'This cannot be undone.'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-crawler-domainManagement-deleteDomain-cancel",
    onClick: hideModal
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainManagement-deleteDomain-delete",
    onClick: deleteDomain,
    isLoading: isLoading,
    color: "danger",
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deleteDomainModal.deleteDomainButtonLabel', {
    defaultMessage: 'Delete domain'
  }))));
};
exports.DeleteDomainModal = DeleteDomainModal;