"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDomainFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../shared/constants");
var _add_domain_form = require("./add_domain_form");
var _add_domain_form_errors = require("./add_domain_form_errors");
var _add_domain_form_submit_button = require("./add_domain_form_submit_button");
var _add_domain_logic = require("./add_domain_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDomainFlyout = () => {
  const {
    isFlyoutVisible
  } = (0, _kea.useValues)(_add_domain_logic.AddDomainLogic);
  const {
    closeFlyout
  } = (0, _kea.useActions)(_add_domain_logic.AddDomainLogic);
  if (isFlyoutVisible) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: closeFlyout
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainFlyout.title', {
      defaultMessage: 'Add a new domain'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      banner: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_add_domain_form_errors.AddDomainFormErrors, null))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainFlyout.description', {
      defaultMessage: 'You can add multiple domains to this index\'s web crawler. Add another domain here and modify the entry points and crawl rules from the "Manage" page.'
    }), /*#__PURE__*/_react.default.createElement("p", null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_add_domain_form.AddDomainForm, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeFlyout
    }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_domain_form_submit_button.AddDomainFormSubmitButton, null))))));
  }
  return null;
};
exports.AddDomainFlyout = AddDomainFlyout;