"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorToText = void 0;
var _i18n = require("@kbn/i18n");
var _error_codes = require("../../../../../../common/types/error_codes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorToText = error => {
  var _error$body, _error$body$attribute, _error$body2, _error$body2$attribut, _error$body3, _error$body3$attribut, _error$body4;
  if (!error) {
    return undefined;
  }
  if (((_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$attribute = _error$body.attributes) === null || _error$body$attribute === void 0 ? void 0 : _error$body$attribute.error_code) === _error_codes.ErrorCode.INDEX_ALREADY_EXISTS) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.error.indexAlreadyExists', {
      defaultMessage: 'This index already exists'
    });
  }
  if (((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : (_error$body2$attribut = _error$body2.attributes) === null || _error$body2$attribut === void 0 ? void 0 : _error$body2$attribut.error_code) === _error_codes.ErrorCode.CONNECTOR_DOCUMENT_ALREADY_EXISTS) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.error.connectorAlreadyExists', {
      defaultMessage: 'A connector for this index already exists'
    });
  }
  if (((_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : (_error$body3$attribut = _error$body3.attributes) === null || _error$body3$attribut === void 0 ? void 0 : _error$body3$attribut.error_code) === _error_codes.ErrorCode.CRAWLER_ALREADY_EXISTS) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.error.connectorAlreadyExists', {
      defaultMessage: 'A connector for this index already exists'
    });
  }
  if ((error === null || error === void 0 ? void 0 : (_error$body4 = error.body) === null || _error$body4 === void 0 ? void 0 : _error$body4.statusCode) === 403) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.error.unauthorizedError', {
      defaultMessage: 'You are not authorized to create this connector'
    });
  } else return _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.steps.buildConnector.error.genericError', {
    defaultMessage: 'We were not able to create your index'
  });
};
exports.errorToText = errorToText;