"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyncJobErrorsTooltip = exports.getSyncJobErrorsLabel = exports.getRunningJobsTooltip = exports.getRunningJobsLabel = exports.getRunningJobsBadgeLabel = exports.getRunningJobsBadgeAriaLabel = exports.getOrphanedJobsTooltip = exports.getOrphanedJobsLabel = exports.getIncompleteConnectorsTooltip = exports.getIncompleteConnectorsBadgeLabel = exports.getIncompleteConnectorBadgeAriaLabel = exports.getIdleJobsTooltip = exports.getIdleJobsLabel = exports.getConnectedConnectorsTooltipContent = exports.getConnectedConnectorsBadgeLabel = exports.getConnectedBadgeAriaLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectedBadgeAriaLabel = connectedCount => _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectedBadgeAriaLabel', {
  defaultMessage: '{number} Connected connectors',
  values: {
    number: connectedCount
  }
});
exports.getConnectedBadgeAriaLabel = getConnectedBadgeAriaLabel;
const getConnectedConnectorsBadgeLabel = connectedCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.connectedBadgeLabel",
  defaultMessage: "{number} Connected",
  values: {
    number: connectedCount
  }
});
exports.getConnectedConnectorsBadgeLabel = getConnectedConnectorsBadgeLabel;
const getConnectedConnectorsTooltipContent = (connectedCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.connectedTooltip",
  defaultMessage: "{connectedCount} {completeConnectorsText} - Number of connectors successfully configured and connected in the last 30 minutes.",
  values: {
    completeConnectorsText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectorTooltipConnected', {
      defaultMessage: `Connected connectors`
    })),
    connectedCount: /*#__PURE__*/_react.default.createElement("b", null, connectedCount)
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.connectedCrawlerTooltip",
  defaultMessage: "{connectedCount} {completeConnectorsText} - Number of crawlers that are configured and connected.",
  values: {
    completeConnectorsText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.crawlerTooltipConnected', {
      defaultMessage: `Connected crawlers`
    })),
    connectedCount: /*#__PURE__*/_react.default.createElement("b", null, connectedCount)
  }
}));
exports.getConnectedConnectorsTooltipContent = getConnectedConnectorsTooltipContent;
const getIncompleteConnectorsTooltip = (incompleteCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.incompleteTooltip",
  defaultMessage: "{incompleteCount} {incompleteConnectorsText} - Number of connectors whose configuration is incomplete. Syncs won't be possible until the connector is fully configured and running.",
  values: {
    incompleteConnectorsText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.incompleteTooltipConnected', {
      defaultMessage: `Incomplete connectors`
    })),
    incompleteCount: /*#__PURE__*/_react.default.createElement("b", null, incompleteCount)
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.incompleteCrawlerTooltip",
  defaultMessage: "{incompleteCount} {incompleteConnectorsText} - Number of crawlers whose configuration is incomplete. These crawlers are not ready to crawl.",
  values: {
    incompleteConnectorsText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.incompleteTooltipCrawler', {
      defaultMessage: `Incomplete crawlers`
    })),
    incompleteCount: /*#__PURE__*/_react.default.createElement("b", null, incompleteCount)
  }
}));
exports.getIncompleteConnectorsTooltip = getIncompleteConnectorsTooltip;
const getIncompleteConnectorsBadgeLabel = incompleteCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.incompleteBadgeLabel",
  defaultMessage: "{incompleteCount} Incomplete",
  values: {
    incompleteCount
  }
});
exports.getIncompleteConnectorsBadgeLabel = getIncompleteConnectorsBadgeLabel;
const getIncompleteConnectorBadgeAriaLabel = incompleteCount => _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.incompleteBadgeAriaLabel', {
  defaultMessage: '{incompleteCount} Incomplete connectors',
  values: {
    incompleteCount
  }
});
exports.getIncompleteConnectorBadgeAriaLabel = getIncompleteConnectorBadgeAriaLabel;
const getRunningJobsLabel = (inProgressCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.runningSyncsTextLabel', {
  defaultMessage: '{syncs} running syncs',
  values: {
    syncs: inProgressCount
  }
}) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.runningCrawlsTextLabel', {
  defaultMessage: '{syncs} running crawls',
  values: {
    syncs: inProgressCount
  }
});
exports.getRunningJobsLabel = getRunningJobsLabel;
const getRunningJobsTooltip = (inProgressCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.runningTooltip",
  defaultMessage: "{inProgressCount} {runningCountText} - Number of running sync jobs. This includes idle syncs.",
  values: {
    inProgressCount: /*#__PURE__*/_react.default.createElement("b", null, inProgressCount),
    runningCountText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectorTooltipRunning', {
      defaultMessage: `Running syncs`
    }))
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.runningCrawlerTooltip",
  defaultMessage: "{inProgressCount} {runningCountText} - Number of running crawls",
  values: {
    inProgressCount: /*#__PURE__*/_react.default.createElement("b", null, inProgressCount),
    runningCountText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.crawlerTooltipRunning', {
      defaultMessage: `Running crawls`
    }))
  }
}));
exports.getRunningJobsTooltip = getRunningJobsTooltip;
const getRunningJobsBadgeAriaLabel = (inProgressCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.runningBadgeAriaLabel', {
  defaultMessage: '{number} Running syncs.',
  values: {
    number: inProgressCount
  }
}) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.runningCrawlerBadgeAriaLabel', {
  defaultMessage: '{number} Running crawls.',
  values: {
    number: inProgressCount
  }
});
exports.getRunningJobsBadgeAriaLabel = getRunningJobsBadgeAriaLabel;
const getRunningJobsBadgeLabel = (inProgressCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.runningBadgeLabel', {
  defaultMessage: '{number} Running syncs',
  values: {
    number: inProgressCount
  }
}) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.runningCrawlerBadgeLabel', {
  defaultMessage: '{number} Running crawls',
  values: {
    number: inProgressCount
  }
});
exports.getRunningJobsBadgeLabel = getRunningJobsBadgeLabel;
const getIdleJobsLabel = idleCount => _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.idleJobsText', {
  defaultMessage: '{idleCount} Idle syncs',
  values: {
    idleCount
  }
});
exports.getIdleJobsLabel = getIdleJobsLabel;
const getIdleJobsTooltip = idleCount => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.idleTooltip",
  defaultMessage: "{idleCount} {idleCountText} - Number of sync jobs which are still running but have not seen any update from the backend connector for more than 1 minute",
  values: {
    idleCount: /*#__PURE__*/_react.default.createElement("b", null, idleCount),
    idleCountText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectorTooltipIdle', {
      defaultMessage: `Idle syncs`
    }))
  }
}));
exports.getIdleJobsTooltip = getIdleJobsTooltip;
const getOrphanedJobsTooltip = (orphanedCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.orphanedTooltip",
  defaultMessage: "{orphanedCount} {orphanedCountText} - Number of sync jobs whose associated connector can't be found. The connector might have been deleted.",
  values: {
    orphanedCount: /*#__PURE__*/_react.default.createElement("b", null, orphanedCount),
    orphanedCountText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectorTooltipOrphaned', {
      defaultMessage: `Orphaned syncs`
    }))
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.orphanedCrawlerTooltip",
  defaultMessage: "{orphanedCount} {orphanedCountText} - Number of crawl jobs whose associated crawler can't be found. The crawler might have been deleted.",
  values: {
    orphanedCount: /*#__PURE__*/_react.default.createElement("b", null, orphanedCount),
    orphanedCountText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.crawlerTooltipOrphaned', {
      defaultMessage: `Orphaned crawls`
    }))
  }
}));
exports.getOrphanedJobsTooltip = getOrphanedJobsTooltip;
const getOrphanedJobsLabel = (orphanedCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.orphanedBadgeAriaLabel', {
  defaultMessage: '{number} Orphaned syncs.',
  values: {
    number: orphanedCount
  }
}) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.orphanedCrawlerBadgeAriaLabel', {
  defaultMessage: '{number} Orphaned crawls.',
  values: {
    number: orphanedCount
  }
});
exports.getOrphanedJobsLabel = getOrphanedJobsLabel;
const getSyncJobErrorsTooltip = (errorCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.errorTooltip",
  defaultMessage: "{errorCount} {errorCountText} - Number of connectors whose last full sync failed",
  values: {
    errorCount: /*#__PURE__*/_react.default.createElement("b", null, errorCount),
    errorCountText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectorTooltipError', {
      defaultMessage: `Sync errors`
    }))
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.connectorStats.errorCrawlerTooltip",
  defaultMessage: "{errorCount} {errorCountText} - Number of crawlers whose last crawl failed",
  values: {
    errorCount: /*#__PURE__*/_react.default.createElement("b", null, errorCount),
    errorCountText: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.crawlerTooltipError', {
      defaultMessage: `Crawl errors`
    }))
  }
}));
exports.getSyncJobErrorsTooltip = getSyncJobErrorsTooltip;
const getSyncJobErrorsLabel = (errorCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.errorBadgeLabel', {
  defaultMessage: '{number} Sync errors',
  values: {
    number: errorCount
  }
}) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.errorCrawlerBadgeLabel', {
  defaultMessage: '{number} Crawl errors',
  values: {
    number: errorCount
  }
});
exports.getSyncJobErrorsLabel = getSyncJobErrorsLabel;