"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchCloudHealth = exports.FetchCloudHealthApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchCloudHealth = async () => {
  const route = '/internal/enterprise_search/stats/cloud_health';
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchCloudHealth = fetchCloudHealth;
const FetchCloudHealthApiLogic = exports.FetchCloudHealthApiLogic = (0, _create_api_logic.createApiLogic)(['enterprise_search_content', 'fetch_cloud_health_api_logic'], fetchCloudHealth);