"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _api = require("../../../../../common/types/api");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _delete_search_application_modal = require("../search_applications/delete_search_application_modal");
var _search_application_connect = require("./connect/search_application_connect");
var _docs_explorer = require("./docs_explorer/docs_explorer");
var _search_application_content = require("./search_application_content");
var _search_application_error = require("./search_application_error");
var _search_application_view_logic = require("./search_application_view_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationView = () => {
  const {
    fetchSearchApplication,
    closeDeleteSearchApplicationModal
  } = (0, _kea.useActions)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    searchApplicationName,
    fetchSearchApplicationApiError,
    fetchSearchApplicationApiStatus,
    hasSchemaConflicts,
    isDeleteModalVisible
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    tabId = _routes.SearchApplicationViewTabs.DOCS_EXPLORER
  } = (0, _reactRouterDom.useParams)();
  (0, _react.useEffect)(() => {
    fetchSearchApplication({
      name: searchApplicationName
    });
  }, [searchApplicationName]);
  if (fetchSearchApplicationApiStatus === _api.Status.ERROR) {
    return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
      isEmptyState: true,
      pageChrome: [searchApplicationName],
      pageViewTelemetry: tabId,
      pageHeader: {
        bottomBorder: false,
        pageTitle: searchApplicationName,
        rightSideItems: []
      },
      searchApplicationName: searchApplicationName,
      emptyState: /*#__PURE__*/_react.default.createElement(_search_application_error.SearchApplicationError, {
        error: fetchSearchApplicationApiError
      }),
      hasSchemaConflicts: hasSchemaConflicts
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_delete_search_application_modal.DeleteSearchApplicationModal, {
    searchApplicationName: searchApplicationName,
    onClose: closeDeleteSearchApplicationModal
  }) : null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.DOCS_EXPLORER}`,
    component: _docs_explorer.SearchApplicationDocsExplorer
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONTENT_PATH,
    component: _search_application_content.SearchApplicationContent
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONTENT}`,
    to: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONTENT}/${_routes.SearchApplicationContentTabs.INDICES}`
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONNECT_PATH,
    component: _search_application_connect.SearchApplicationConnect
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONNECT}`,
    to: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONNECT}/${_routes.SearchApplicationConnectTabs.SEARCHAPI}`
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    isEmptyState: true,
    pageChrome: [searchApplicationName],
    pageViewTelemetry: tabId,
    pageHeader: {
      bottomBorder: false,
      pageTitle: searchApplicationName,
      rightSideItems: []
    },
    searchApplicationName: searchApplicationName,
    hasSchemaConflicts: hasSchemaConflicts
  }, /*#__PURE__*/_react.default.createElement(_search_application_error.SearchApplicationError, {
    notFound: true
  })))));
};
exports.SearchApplicationView = SearchApplicationView;