"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationIndicesLogic = void 0;
var _kea = require("kea");
var _update_search_application_api_logic = require("../../api/search_applications/update_search_application_api_logic");
var _search_application_view_logic = require("./search_application_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationIndicesLogic = exports.SearchApplicationIndicesLogic = (0, _kea.kea)({
  actions: {
    addIndicesToSearchApplication: indices => ({
      indices
    }),
    closeAddIndicesFlyout: () => true,
    openAddIndicesFlyout: () => true,
    removeIndexFromSearchApplication: indexName => ({
      indexName
    })
  },
  connect: {
    actions: [_search_application_view_logic.SearchApplicationViewLogic, ['fetchSearchApplication'], _update_search_application_api_logic.UpdateSearchApplicationApiLogic, ['makeRequest as updateSearchApplicationRequest', 'apiSuccess as searchApplicationUpdated']],
    values: [_search_application_view_logic.SearchApplicationViewLogic, ['searchApplicationData', 'searchApplicationName', 'isLoadingSearchApplication']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    addIndicesToSearchApplication: ({
      indices
    }) => {
      if (!values.searchApplicationData) return;
      const existingIndicesNames = values.searchApplicationData.indices.map(index => index.name);
      const updatedIndices = Array.from(new Set([...existingIndicesNames, ...indices]));
      actions.updateSearchApplicationRequest({
        name: values.searchApplicationName,
        indices: updatedIndices,
        template: values.searchApplicationData.template
      });
    },
    searchApplicationUpdated: () => {
      actions.fetchSearchApplication({
        name: values.searchApplicationName
      });
    },
    removeIndexFromSearchApplication: ({
      indexName
    }) => {
      if (!values.searchApplicationData) return;
      const updatedIndices = values.searchApplicationData.indices.filter(index => index.name !== indexName).map(index => index.name);
      actions.updateSearchApplicationRequest({
        name: values.searchApplicationName,
        indices: updatedIndices,
        template: values.searchApplicationData.template
      });
    }
  }),
  path: ['enterprise_search', 'content', 'search_application_indices_logic'],
  reducers: {
    addIndicesFlyoutOpen: [false, {
      closeAddIndicesFlyout: () => false,
      openAddIndicesFlyout: () => true
    }]
  }
});