"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEngineSchemaLogic = void 0;
var _kea = require("kea");
var _schema_base_logic = require("./schema_base_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEngineSchemaLogic = exports.MetaEngineSchemaLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'meta_engine_schema_logic'],
  connect: {
    values: [_schema_base_logic.SchemaBaseLogic, ['dataLoading', 'schema']],
    actions: [_schema_base_logic.SchemaBaseLogic, ['loadSchema', 'onSchemaLoad']]
  },
  reducers: {
    fields: [{}, {
      // @ts-expect-error upgrade typescript v5.1.6
      onSchemaLoad: (_, {
        fields
      }) => fields
    }],
    conflictingFields: [{}, {
      // @ts-expect-error upgrade typescript v5.1.6
      onSchemaLoad: (_, {
        conflictingFields
      }) => conflictingFields
    }]
  },
  selectors: {
    conflictingFieldsCount: [selectors => [selectors.conflictingFields], conflictingFields => Object.keys(conflictingFields).length],
    hasConflicts: [selectors => [selectors.conflictingFieldsCount], conflictingFieldsCount => conflictingFieldsCount > 0]
  }
});