"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncatedEnginesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _encode_path_params = require("../../../utils/encode_path_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TruncatedEnginesList = ({
  engines,
  cutoff = 3
}) => {
  if (!(engines !== null && engines !== void 0 && engines.length)) return null;
  const displayedEngines = engines.slice(0, cutoff);
  const hiddenEngines = engines.slice(cutoff);
  const SEPARATOR = ', ';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, displayedEngines.map((engineName, i) => {
    const isLast = i === displayedEngines.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: engineName
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_SCHEMA_PATH, {
        engineName
      }),
      "data-test-subj": "displayedEngine"
    }, engineName), !isLast ? SEPARATOR : '');
  }), hiddenEngines.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, SEPARATOR, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: hiddenEngines.join(SEPARATOR),
    "data-test-subj": "hiddenEnginesTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "both"
  }, "+", hiddenEngines.length))));
};
exports.TruncatedEnginesList = TruncatedEnginesList;