"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultField = void 0;
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
require("./result_field.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultField = ({
  field,
  raw,
  snippet,
  type
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "appSearchResultField"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "appSearchResultField__key eui-textTruncate"
  }, type && /*#__PURE__*/_react.default.createElement(_.ResultToken, {
    fieldType: type
  }), field), /*#__PURE__*/_react.default.createElement("div", {
    className: "appSearchResultField__separator",
    "aria-hidden": true
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "appSearchResultField__value"
  }, /*#__PURE__*/_react.default.createElement(_.ResultFieldValue, {
    className: "eui-textTruncate",
    raw: raw,
    snippet: snippet,
    type: type
  })));
};
exports.ResultField = ResultField;