"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProximityBoostForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _constants = require("../../constants");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProximityBoostForm = ({
  boost,
  index,
  name
}) => {
  const {
    updateBoostSelectOption,
    updateBoostCenter
  } = (0, _kea.useActions)(_.RelevanceTuningLogic);
  const currentBoostCenter = boost.center !== undefined ? boost.center.toString() : '';
  const currentBoostFunction = boost.function || _types.ProximityBoostFunction.Gaussian;
  const functionOptions = Object.values(_types.ProximityBoostFunction).map(boostFunction => ({
    value: boostFunction,
    text: _constants.PROXIMITY_BOOST_FUNCTION_DISPLAY_MAP[boostFunction]
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.proximity.functionDropDownLabel', {
      defaultMessage: 'Function'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: `proximity-${_types.BoostType.Proximity}${index}`,
    options: functionOptions,
    value: currentBoostFunction,
    onChange: e => updateBoostSelectOption(name, index, 'function', e.target.value),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.proximity.centerLabel', {
      defaultMessage: 'Center'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: currentBoostCenter,
    onChange: e => updateBoostCenter(name, index, e.target.value),
    fullWidth: true
  })));
};
exports.ProximityBoostForm = ProximityBoostForm;