"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEngineCreation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _app_logic = require("../../app_logic");
var _engines = require("../engines");
var _layout = require("../layout");
var _constants = require("./constants");
var _meta_engine_creation_logic = require("./meta_engine_creation_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const engineNameToComboBoxOption = engineName => ({
  label: engineName
});
const comboBoxOptionToEngineName = option => option.label;
const MetaEngineCreation = () => {
  const {
    configuredLimits: {
      engine: {
        maxEnginesPerMetaEngine
      }
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    fetchIndexedEngineNames,
    setRawName,
    setSelectedIndexedEngineNames,
    submitEngine
  } = (0, _kea.useActions)(_meta_engine_creation_logic.MetaEngineCreationLogic);
  const {
    rawName,
    name,
    indexedEngineNames,
    selectedIndexedEngineNames,
    isLoading
  } = (0, _kea.useValues)(_meta_engine_creation_logic.MetaEngineCreationLogic);
  (0, _react.useEffect)(() => {
    fetchIndexedEngineNames();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: [_engines.ENGINES_TITLE, _constants.META_ENGINE_CREATION_TITLE],
    pageHeader: {
      pageTitle: _constants.META_ENGINE_CREATION_TITLE,
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.META_ENGINE_CREATION_FORM_META_ENGINE_DESCRIPTION, /*#__PURE__*/_react.default.createElement("br", null), _constants.META_ENGINE_CREATION_FORM_DOCUMENTATION_DESCRIPTION)
    },
    "data-test-subj": "MetaEngineCreation"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    "data-test-subj": "MetaEngineCreationForm",
    onSubmit: e => {
      e.preventDefault();
      submitEngine();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _constants.META_ENGINE_CREATION_FORM_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "MetaEngineCreationNameFormRow",
    label: _constants.META_ENGINE_CREATION_FORM_ENGINE_NAME_LABEL,
    helpText: name.length > 0 && rawName !== name ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.SANITIZED_NAME_NOTE, " ", /*#__PURE__*/_react.default.createElement("strong", null, name)) : _constants.ALLOWED_CHARS_NOTE,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "engine-name",
    value: rawName,
    onChange: event => setRawName(event.currentTarget.value),
    fullWidth: true,
    "data-test-subj": "MetaEngineCreationNameInput",
    placeholder: _constants.META_ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER,
    autoFocus: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.META_ENGINE_CREATION_FORM_ENGINE_SOURCE_ENGINES_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "MetaEngineCreationSourceEnginesInput",
    options: indexedEngineNames.map(engineNameToComboBoxOption),
    selectedOptions: selectedIndexedEngineNames.map(engineNameToComboBoxOption),
    onChange: options => {
      setSelectedIndexedEngineNames(options.map(comboBoxOptionToEngineName));
    }
  })), selectedIndexedEngineNames.length > maxEnginesPerMetaEngine && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: (0, _constants.META_ENGINE_CREATION_FORM_MAX_SOURCE_ENGINES_WARNING_TITLE)(maxEnginesPerMetaEngine)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: name.length === 0 || selectedIndexedEngineNames.length === 0 || selectedIndexedEngineNames.length > maxEnginesPerMetaEngine,
    isLoading: isLoading,
    type: "submit",
    "data-test-subj": "NewMetaEngineSubmitButton",
    color: "success",
    fill: true
  }, _constants.META_ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL))));
};
exports.MetaEngineCreation = MetaEngineCreation;