"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureElasticsearchEngine = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _engine_creation_logic = require("./engine_creation_logic");
var _search_index_selectable = require("./search_index_selectable");
require("./engine_creation.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderIndexOption = (option, searchValue) => {
  var _option$label;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, (_option$label = option.label) !== null && _option$label !== void 0 ? _option$label : ''), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_search_index_selectable.IndexStatusDetails, {
    option: option
  }));
};
const ConfigureElasticsearchEngine = () => {
  const {
    aliasName,
    aliasNameErrorMessage,
    aliasRawName,
    indicesFormatted,
    isAliasAllowed,
    isAliasRequired,
    isLoading,
    isLoadingIndices,
    isSubmitDisabled,
    name,
    rawName,
    showAliasNameErrorMessages
  } = (0, _kea.useValues)(_engine_creation_logic.EngineCreationLogic);
  const {
    loadIndices,
    setIsAliasAllowed,
    setAliasRawName,
    setCreationStep,
    setRawName,
    setSelectedIndex
  } = (0, _kea.useActions)(_engine_creation_logic.EngineCreationLogic);
  const onChange = options => {
    var _selectedOption$label, _selectedOption$alias, _selectedOption$alias2;
    const selectedOption = options.find(option => option.checked === 'on');
    setSelectedIndex((_selectedOption$label = selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.label) !== null && _selectedOption$label !== void 0 ? _selectedOption$label : '');

    // If this is an alias, remove the alias name. Do nothing if an option was deselected
    if ((_selectedOption$alias = selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.alias) !== null && _selectedOption$alias !== void 0 ? _selectedOption$alias : false) setAliasRawName('');

    // Set isAliasAllowed depending on if the selectedOption is an alias or not.
    // Set it to true if an option was deselected.
    setIsAliasAllowed((_selectedOption$alias2 = !(selectedOption !== null && selectedOption !== void 0 && selectedOption.alias)) !== null && _selectedOption$alias2 !== void 0 ? _selectedOption$alias2 : true);
  };
  const aliasOptionalOrRequired = !isAliasAllowed ? 'Disabled' : isAliasRequired ? 'Required' : 'Optional';
  (0, _react.useEffect)(() => {
    loadIndices();
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "entSearch__createEngineLayout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: [{
      onClick: () => setCreationStep(_engine_creation_logic.EngineCreationSteps.SelectStep),
      status: 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.searchEngineType.label', {
        defaultMessage: 'Search engine type'
      })
    }, {
      onClick: () => {},
      status: 'current',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.configuration.label', {
        defaultMessage: 'Configuration'
      })
    }, {
      onClick: () => {},
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.review.label', {
        defaultMessage: 'Review'
      })
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    "data-test-subj": "EngineCreationForm",
    onSubmit: e => {
      e.preventDefault();
      setCreationStep(_engine_creation_logic.EngineCreationSteps.ReviewStep);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _constants.ENGINE_CREATION_FORM_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.elasticsearchIndex.description', {
    defaultMessage: 'Provide a unique name and select an index for your App Search engine.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "EngineCreationNameFormRow",
    label: _constants.ENGINE_CREATION_FORM_ENGINE_NAME_LABEL,
    helpText: name.length > 0 && rawName !== name ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.SANITIZED_NAME_NOTE, " ", /*#__PURE__*/_react.default.createElement("strong", null, name)) : _constants.ALLOWED_CHARS_NOTE,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "engine-name",
    value: rawName,
    onChange: event => setRawName(event.currentTarget.value),
    autoComplete: "off",
    fullWidth: true,
    "data-test-subj": "EngineCreationNameInput",
    placeholder: _constants.ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER,
    autoFocus: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.callout.title', {
      defaultMessage: 'App Search has index and alias name requirements'
    }),
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.callout.body', {
    defaultMessage: `
                    App Search engines can only be created with indices or
                    aliases prefixed with "search-". If you select an index that
                    doesn’t start with "search-", an alias to that index will be
                    created and used.
                  `
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.searchIndexSelectable.label', {
      defaultMessage: 'Select the Elasticsearch index you’d like to use'
    }),
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.searchIndexSelectable.helpText', {
      defaultMessage: "Select an index or alias prefixed with 'search-' or create a new alias below"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    options: indicesFormatted,
    singleSelection: true,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.elasticsearchIndex.indexSelectorAriaLabel', {
      defaultMessage: 'Select the Elasticsearch index you’d like to use'
    }),
    isLoading: isLoadingIndices,
    listProps: {
      bordered: true,
      rowHeight: 56
    },
    onChange: onChange,
    loadingMessage: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.elasticsearchIndex.selectable.loading', {
      defaultMessage: 'Loading Elasticsearch indices'
    }),
    emptyMessage: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.elasticsearchIndex.selectable.empty', {
      defaultMessage: 'No Elasticsearch indices available'
    }),
    renderOption: renderIndexOption,
    "data-test-subj": "SearchIndexSelectable",
    className: "entSearch__indexSelectable"
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "AliasNameFormRow",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.aliasName.label', {
      defaultMessage: 'Alias name'
    }),
    helpText: aliasName.length > 0 && aliasRawName !== aliasName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.aliasName.prefixAndNamed.helpText', {
      defaultMessage: "Alias names must be prefixed with 'search-' in order to be used with App Search engines. Your alias will be named"
    }), "\xA0", /*#__PURE__*/_react.default.createElement("b", null, aliasName)) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.aliasName.prefix.helpText', {
      defaultMessage: "Alias names must be prefixed with 'search-' in order to be used with App Search engines"
    }),
    fullWidth: true,
    isInvalid: showAliasNameErrorMessages,
    error: aliasNameErrorMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "alias-name",
    value: aliasRawName,
    onChange: event => setAliasRawName(event.currentTarget.value),
    autoComplete: "off",
    fullWidth: true,
    "data-test-subj": "AliasNameInput",
    prepend: aliasOptionalOrRequired,
    disabled: !isAliasAllowed,
    isInvalid: showAliasNameErrorMessages
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "NewEngineBackButton",
    color: "primary",
    iconType: "arrowLeft",
    onClick: () => setCreationStep(_engine_creation_logic.EngineCreationSteps.SelectStep)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.backButton.label', {
    defaultMessage: 'Back'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isSubmitDisabled,
    isLoading: isLoading,
    type: "submit",
    "data-test-subj": "NewEngineContinueButton",
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.continue.label', {
    defaultMessage: 'Continue'
  })))))));
};
exports.ConfigureElasticsearchEngine = ConfigureElasticsearchEngine;