"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortingView = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapSortingOptionForEuiSelect = option => ({
  text: option.label,
  value: option.value
});
const getValueFromOption = option => option.value;
const SortingView = ({
  onChange,
  options,
  value
}) => {
  // If we don't have the value in options, unset it
  const valuesFromOptions = options.map(getValueFromOption);
  const selectedValue = value && !valuesFromOptions.includes(value) ? undefined : value;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: options.map(wrapSortingOptionForEuiSelect),
    value: selectedValue,
    prepend: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.sortBy', {
      defaultMessage: 'Sort by'
    }),
    onChange: event => onChange(event.target.value),
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.search.sortBy.ariaLabel', {
      defaultMessage: 'Sort results by'
    })
  }));
};
exports.SortingView = SortingView;