"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCreationButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _document_creation = require("../../document_creation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentCreationButton = () => {
  const {
    showCreationModes
  } = (0, _kea.useActions)(_document_creation.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "IndexDocumentsButton",
    onClick: showCreationModes
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.indexDocuments', {
    defaultMessage: 'Index documents'
  })), /*#__PURE__*/_react.default.createElement(_document_creation.DocumentCreationFlyout, null));
};
exports.DocumentCreationButton = DocumentCreationButton;