"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadJsonFileTabContent = exports.UploadJsonFileFooterContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _app_logic = require("../../../app_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UploadJsonFileTabContent = () => {
  const {
    configuredLimits: {
      engine: {
        maxDocumentByteSize
      }
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    isUploading,
    errors
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const {
    setFileInput
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.uploadJsonFile.label', {
    defaultMessage: 'If you have a .json file, drag and drop or upload it. Ensure the JSON is valid and that each document object is less than {maxDocumentByteSize} bytes.',
    values: {
      maxDocumentByteSize
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    onChange: files => setFileInput(files !== null && files !== void 0 && files.length ? files[0] : null),
    accept: "application/json",
    fullWidth: true,
    isLoading: isUploading,
    isInvalid: errors.length > 0
  }));
};
exports.UploadJsonFileTabContent = UploadJsonFileTabContent;
const UploadJsonFileFooterContent = () => {
  const {
    fileInput,
    isUploading
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const {
    onSubmitFile,
    closeDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeDocumentCreation
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onSubmitFile,
    isLoading: isUploading,
    isDisabled: !fileInput
  }, _constants.CONTINUE_BUTTON_LABEL)));
};
exports.UploadJsonFileFooterContent = UploadJsonFileFooterContent;