"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PasteJsonTextTabContent = exports.PasteJsonTextFooterContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _app_logic = require("../../../app_logic");
require("./paste_json_text.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PasteJsonTextTabContent = () => {
  const {
    configuredLimits: {
      engine: {
        maxDocumentByteSize
      }
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    textInput,
    errors
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const {
    setTextInput
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.pasteJsonText.description', {
    defaultMessage: 'Paste an array of JSON documents. Ensure the JSON is valid and that each document object is less than {maxDocumentByteSize} bytes.',
    values: {
      maxDocumentByteSize
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    value: textInput,
    onChange: e => setTextInput(e.target.value),
    isInvalid: errors.length > 0,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.pasteJsonText.label', {
      defaultMessage: 'Paste JSON here'
    }),
    className: "pasteJsonTextArea",
    fullWidth: true,
    rows: 12
  }));
};
exports.PasteJsonTextTabContent = PasteJsonTextTabContent;
const PasteJsonTextFooterContent = () => {
  const {
    textInput,
    isUploading
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const {
    onSubmitJson,
    closeDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeDocumentCreation
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onSubmitJson,
    isLoading: isUploading,
    isDisabled: !textInput
  }, _constants.CONTINUE_BUTTON_LABEL)));
};
exports.PasteJsonTextFooterContent = PasteJsonTextFooterContent;