"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationCreation = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _layout = require("../../layout");
var _multi_input_rows = require("../../multi_input_rows");
var _constants = require("../constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationCreation = () => {
  const {
    createCuration
  } = (0, _kea.useActions)(_.CurationsLogic);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _utils.getCurationsBreadcrumbs)([_constants.CREATE_NEW_CURATION_TITLE]),
    pageHeader: {
      pageTitle: _constants.CREATE_NEW_CURATION_TITLE
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.create.curationQueriesTitle', {
    defaultMessage: 'Curation queries'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.create.curationQueriesDescription', {
    defaultMessage: 'Add one or multiple queries to curate. You will be able add or remove more queries later.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_multi_input_rows.MultiInputRows, {
    id: "createNewCuration",
    addRowText: _constants.QUERY_INPUTS_BUTTON,
    inputPlaceholder: _constants.QUERY_INPUTS_PLACEHOLDER,
    onSubmit: queries => createCuration(queries)
  })));
};
exports.CurationCreation = CurationCreation;