"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlDetailLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _engine = require("../engine");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlDetailLogic = exports.CrawlDetailLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'crawler', 'crawl_detail_logic'],
  actions: {
    closeFlyout: true,
    fetchCrawlRequest: requestId => ({
      requestId
    }),
    onRecieveCrawlRequest: crawlRequestFromServer => ({
      crawlRequestFromServer
    }),
    openFlyout: true,
    setSelectedTab: selectedTab => ({
      selectedTab
    })
  },
  reducers: {
    crawlRequest: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      onRecieveCrawlRequest: (_, {
        crawlRequestFromServer
      }) => (0, _utils.crawlRequestWithDetailsServerToClient)(crawlRequestFromServer)
    }],
    crawlRequestFromServer: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      onRecieveCrawlRequest: (_, {
        crawlRequestFromServer
      }) => crawlRequestFromServer
    }],
    dataLoading: [true, {
      fetchCrawlRequest: () => true,
      onRecieveCrawlRequest: () => false
    }],
    flyoutClosed: [true, {
      openFlyout: () => false,
      closeFlyout: () => true
    }],
    selectedTab: ['preview', {
      // @ts-expect-error upgrade typescript v5.1.6
      openFlyout: () => 'preview',
      // @ts-expect-error upgrade typescript v5.1.6
      setSelectedTab: (_, {
        selectedTab
      }) => selectedTab
    }]
  },
  listeners: ({
    actions
  }) => ({
    fetchCrawlRequest: async ({
      requestId
    }) => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const response = await http.get(`/internal/app_search/engines/${engineName}/crawler/crawl_requests/${requestId}`);
        actions.onRecieveCrawlRequest(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});