"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlSelectDomainsModalLogic = void 0;
var _kea = require("kea");
var _crawler_logic = require("../../crawler_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlSelectDomainsModalLogic = exports.CrawlSelectDomainsModalLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'crawler', 'crawl_select_domains_modal'],
  actions: () => ({
    hideModal: true,
    onSelectDomainUrls: domainUrls => ({
      domainUrls
    }),
    showModal: true
  }),
  reducers: () => ({
    isDataLoading: [false, {
      [_crawler_logic.CrawlerLogic.actionTypes.startCrawl]: () => true,
      [_crawler_logic.CrawlerLogic.actionTypes.onStartCrawlRequestComplete]: () => false
    }],
    isModalVisible: [false, {
      showModal: () => true,
      hideModal: () => false,
      [_crawler_logic.CrawlerLogic.actionTypes.onStartCrawlRequestComplete]: () => false
    }],
    selectedDomainUrls: [[], {
      showModal: () => [],
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectDomainUrls: (_, {
        domainUrls
      }) => domainUrls
    }]
  })
});