"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _queryString = _interopRequireDefault(require("query-string"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _kibana = require("../../../../shared/kibana");
var _constants = require("../constants");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsFilters = () => {
  const {
    allTags
  } = (0, _kea.useValues)(_.AnalyticsLogic);
  const {
    history
  } = (0, _kea.useValues)(_kibana.KibanaLogic);

  // Parse out existing filters from URL query string
  const {
    start,
    end,
    tag
  } = _queryString.default.parse(history.location.search);
  const [startDate, setStartDate] = (0, _react.useState)(start ? (0, _moment.default)(start, _constants.SERVER_DATE_FORMAT) : (0, _moment.default)(_constants.DEFAULT_START_DATE));
  const [endDate, setEndDate] = (0, _react.useState)(end ? (0, _moment.default)(end, _constants.SERVER_DATE_FORMAT) : (0, _moment.default)(_constants.DEFAULT_END_DATE));
  const [currentTag, setCurrentTag] = (0, _react.useState)(tag || '');

  // Set the current URL query string on filter
  const onApplyFilters = () => {
    const search = _queryString.default.stringify({
      start: (0, _moment.default)(startDate).format(_constants.SERVER_DATE_FORMAT),
      end: (0, _moment.default)(endDate).format(_constants.SERVER_DATE_FORMAT),
      tag: currentTag || undefined
    });
    history.push({
      search
    });
  };
  const hasInvalidDateRange = startDate > endDate;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: (0, _utils.convertTagsToSelectOptions)(allTags),
    value: currentTag,
    onChange: e => setCurrentTag(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.filters.tagAriaLabel', {
      defaultMessage: 'Filter by analytics tag"'
    }),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: startDate,
      onChange: date => date && setStartDate(date),
      startDate: startDate,
      endDate: endDate,
      isInvalid: hasInvalidDateRange,
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.filters.startDateAriaLabel', {
        defaultMessage: 'Filter by start date'
      }),
      locale: _i18n.i18n.getLocale()
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: endDate,
      onChange: date => date && setEndDate(date),
      startDate: startDate,
      endDate: endDate,
      isInvalid: hasInvalidDateRange,
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.filters.endDateAriaLabel', {
        defaultMessage: 'Filter by end date'
      }),
      locale: _i18n.i18n.getLocale()
    }),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: hasInvalidDateRange,
    onClick: onApplyFilters
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.filters.applyButtonLabel', {
    defaultMessage: 'Apply filters'
  }))));
};
exports.AnalyticsFilters = AnalyticsFilters;