"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsLogic = void 0;
var _kea = require("kea");
var _queryString = _interopRequireDefault(require("query-string"));
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _engine = require("../engine");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsLogic = exports.AnalyticsLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'analytics_logic'],
  actions: () => ({
    onAnalyticsDataLoad: data => data,
    onQueryDataLoad: data => data,
    loadAnalyticsData: true,
    loadQueryData: query => query
  }),
  reducers: () => ({
    dataLoading: [true, {
      loadAnalyticsData: () => true,
      loadQueryData: () => true,
      onAnalyticsDataLoad: () => false,
      onQueryDataLoad: () => false
    }],
    allTags: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        allTags
      }) => allTags,
      // @ts-expect-error upgrade typescript v5.1.6
      onQueryDataLoad: (_, {
        allTags
      }) => allTags
    }],
    recentQueries: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        recentQueries
      }) => recentQueries
    }],
    topQueries: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        topQueries
      }) => topQueries
    }],
    topQueriesNoResults: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        topQueriesNoResults
      }) => topQueriesNoResults
    }],
    topQueriesNoClicks: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        topQueriesNoClicks
      }) => topQueriesNoClicks
    }],
    topQueriesWithClicks: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        topQueriesWithClicks
      }) => topQueriesWithClicks
    }],
    totalQueries: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        totalQueries
      }) => totalQueries
    }],
    totalQueriesNoResults: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        totalQueriesNoResults
      }) => totalQueriesNoResults
    }],
    totalClicks: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        totalClicks
      }) => totalClicks
    }],
    queriesPerDay: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        queriesPerDay
      }) => queriesPerDay
    }],
    queriesNoResultsPerDay: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        queriesNoResultsPerDay
      }) => queriesNoResultsPerDay
    }],
    clicksPerDay: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        clicksPerDay
      }) => clicksPerDay
    }],
    totalQueriesForQuery: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      onQueryDataLoad: (_, {
        totalQueriesForQuery
      }) => totalQueriesForQuery
    }],
    queriesPerDayForQuery: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onQueryDataLoad: (_, {
        queriesPerDayForQuery
      }) => queriesPerDayForQuery
    }],
    topClicksForQuery: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onQueryDataLoad: (_, {
        topClicksForQuery
      }) => topClicksForQuery
    }],
    startDate: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      onAnalyticsDataLoad: (_, {
        startDate
      }) => startDate,
      // @ts-expect-error upgrade typescript v5.1.6
      onQueryDataLoad: (_, {
        startDate
      }) => startDate
    }]
  }),
  listeners: ({
    actions
  }) => ({
    loadAnalyticsData: async () => {
      const {
        history
      } = _kibana.KibanaLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const {
          start,
          end,
          tag
        } = _queryString.default.parse(history.location.search);
        const query = {
          start: start || _constants.DEFAULT_START_DATE,
          end: end || _constants.DEFAULT_END_DATE,
          tag,
          size: 20
        };
        const url = `/internal/app_search/engines/${engineName}/analytics/queries`;
        const response = await http.get(url, {
          query
        });
        actions.onAnalyticsDataLoad(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    loadQueryData: async query => {
      const {
        history
      } = _kibana.KibanaLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const {
          start,
          end,
          tag
        } = _queryString.default.parse(history.location.search);
        const queryParams = {
          start: start || _constants.DEFAULT_START_DATE,
          end: end || _constants.DEFAULT_END_DATE,
          tag
        };
        const url = `/internal/app_search/engines/${engineName}/analytics/queries/${query}`;
        const response = await http.get(url, {
          query: queryParams
        });
        actions.onQueryDataLoad(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});