"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableEnhancedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-enhanced-plugin/public");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _rxjs = require("rxjs");
var _dynamic_action_storage = require("./embeddables/dynamic_action_storage");
var _get_dynamic_actions_state = require("./get_dynamic_actions_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class EmbeddableEnhancedPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "uiActions", void 0);
    this.context = context;
  }
  setup(core, plugins) {
    return {};
  }
  start(core, plugins) {
    this.uiActions = plugins.uiActionsEnhanced;
    return {
      initializeReactEmbeddableDynamicActions: this.initializeDynamicActions.bind(this)
    };
  }
  stop() {}
  initializeDynamicActions(uuid, getTitle, state) {
    const dynamicActionsState$ = new _rxjs.BehaviorSubject((0, _get_dynamic_actions_state.getDynamicActionsState)(state.enhancements));
    const api = {
      dynamicActionsState$,
      setDynamicActions: enhancements => {
        dynamicActionsState$.next((0, _get_dynamic_actions_state.getDynamicActionsState)(enhancements));
      }
    };
    const storage = new _dynamic_action_storage.DynamicActionStorage(uuid, getTitle, api);
    const dynamicActions = new _public.UiActionsEnhancedDynamicActionManager({
      isCompatible: async context => {
        const {
          embeddable
        } = context;
        return (0, _presentationPublishing.apiHasUniqueId)(embeddable) && embeddable.uuid === uuid;
      },
      storage,
      uiActions: this.uiActions
    });
    return {
      dynamicActionsApi: {
        ...api,
        enhancements: {
          dynamicActions
        }
      },
      dynamicActionsComparator: {
        enhancements: [dynamicActionsState$, api.setDynamicActions, (a, b) => {
          return (0, _reactFastCompare.default)((0, _get_dynamic_actions_state.getDynamicActionsState)(a), (0, _get_dynamic_actions_state.getDynamicActionsState)(b));
        }]
      },
      serializeDynamicActions: () => {
        return {
          enhancements: dynamicActionsState$.getValue()
        };
      },
      startDynamicActions: () => {
        const stop = this.startDynamicActions(dynamicActions);
        return {
          stopDynamicActions: stop
        };
      }
    };
  }
  startDynamicActions(dynamicActions) {
    dynamicActions.start().catch(error => {
      /* eslint-disable no-console */

      console.log('Failed to start embeddable dynamic actions', dynamicActions);
      console.error(error);
      /* eslint-enable */
    });
    const stop = () => {
      dynamicActions.stop().catch(error => {
        /* eslint-disable no-console */

        console.log('Failed to stop embeddable dynamic actions', dynamicActions);
        console.error(error);
        /* eslint-enable */
      });
    };
    return stop;
  }
}
exports.EmbeddableEnhancedPlugin = EmbeddableEnhancedPlugin;