"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConversationRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createConversationRoute = router => {
  router.versioned.post({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.ConversationCreateProps)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      // Perform license and authenticated user checks
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const dataClient = await ctx.elasticAssistant.getAIAssistantConversationsDataClient();
      const createdConversation = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.createConversation({
        conversation: request.body
      }));
      if (createdConversation == null) {
        return assistantResponse.error({
          body: `conversation with title: "${request.body.title}" was not created`,
          statusCode: 400
        });
      }
      return response.ok({
        body: _elasticAssistantCommon.ConversationResponse.parse(createdConversation)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.createConversationRoute = createConversationRoute;