"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEvaluateRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _build_response = require("../../lib/build_response");
var _helpers = require("../helpers");
var _graphs = require("../../lib/langchain/graphs");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEvaluateRoute = router => {
  router.versioned.get({
    access: _elasticAssistantCommon.INTERNAL_API_ACCESS,
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_EVALUATE_URL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      response: {
        200: {
          body: {
            custom: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.GetEvaluateResponse)
          }
        }
      }
    }
  }, async (context, request, response) => {
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    const assistantContext = ctx.elasticAssistant;
    const logger = assistantContext.logger.get('evaluate');

    // Perform license, authenticated user and evaluation FF checks
    const checkResponse = await (0, _helpers.performChecks)({
      capability: 'assistantModelEvaluation',
      context: ctx,
      request,
      response
    });
    if (!checkResponse.isSuccess) {
      return checkResponse.response;
    }

    // Fetch datasets from LangSmith // TODO: plumb apiKey so this will work in cloud w/o env vars
    const datasets = await (0, _utils.fetchLangSmithDatasets)({
      logger
    });
    try {
      return response.ok({
        body: {
          graphs: Object.keys(_graphs.ASSISTANT_GRAPH_MAP),
          datasets
        }
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      const resp = (0, _build_response.buildResponse)(response);
      return resp.error({
        body: {
          error: error.message
        },
        statusCode: error.statusCode
      });
    }
  });
};
exports.getEvaluateRoute = getEvaluateRoute;