"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleGraphError = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _helpers = require("../../../helpers/helpers");
var _event_based_telemetry = require("../../../../../lib/telemetry/event_based_telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleGraphError = async ({
  apiConfig,
  attackDiscoveryId,
  authenticatedUser,
  dataClient,
  err,
  latestReplacements,
  logger,
  telemetry
}) => {
  try {
    logger.error(err);
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    const currentAd = await dataClient.getAttackDiscovery({
      id: attackDiscoveryId,
      authenticatedUser
    });
    if (currentAd === null || (currentAd === null || currentAd === void 0 ? void 0 : currentAd.status) === 'canceled') {
      return;
    }
    await dataClient.updateAttackDiscovery({
      attackDiscoveryUpdateProps: {
        attackDiscoveries: [],
        status: _helpers.attackDiscoveryStatus.failed,
        id: attackDiscoveryId,
        replacements: latestReplacements,
        backingIndex: currentAd.backingIndex,
        failureReason: error.message
      },
      authenticatedUser
    });
    telemetry.reportEvent(_event_based_telemetry.ATTACK_DISCOVERY_ERROR_EVENT.eventType, {
      actionTypeId: apiConfig.actionTypeId,
      errorMessage: error.message,
      model: apiConfig.model,
      provider: apiConfig.provider
    });
  } catch (updateErr) {
    const updateError = (0, _securitysolutionEsUtils.transformError)(updateErr);
    telemetry.reportEvent(_event_based_telemetry.ATTACK_DISCOVERY_ERROR_EVENT.eventType, {
      actionTypeId: apiConfig.actionTypeId,
      errorMessage: updateError.message,
      model: apiConfig.model,
      provider: apiConfig.provider
    });
  }
};
exports.handleGraphError = handleGraphError;