"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.promptGroupId = exports.promptDictionary = exports.localPrompts = void 0;
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const promptGroupId = exports.promptGroupId = {
  attackDiscovery: 'attackDiscovery',
  aiAssistant: 'aiAssistant'
};
const promptDictionary = exports.promptDictionary = {
  systemPrompt: `systemPrompt`,
  userPrompt: `userPrompt`,
  chatTitle: `chatTitle`,
  attackDiscoveryDefault: `default`,
  attackDiscoveryRefine: `refine`,
  attackDiscoveryContinue: `continue`,
  attackDiscoveryDetailsMarkdown: `detailsMarkdown`,
  attackDiscoveryEntitySummaryMarkdown: `entitySummaryMarkdown`,
  attackDiscoveryMitreAttackTactics: `mitreAttackTactics`,
  attackDiscoverySummaryMarkdown: `summaryMarkdown`,
  attackDiscoveryGenerationTitle: `generationTitle`,
  attackDiscoveryGenerationInsights: `generationInsights`
};
const localPrompts = exports.localPrompts = [{
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'openai',
  prompt: {
    default: _prompts.DEFAULT_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.DEFAULT_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'bedrock',
  prompt: {
    default: _prompts.BEDROCK_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'gemini',
  prompt: {
    default: _prompts.GEMINI_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.userPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'gemini',
  prompt: {
    default: _prompts.GEMINI_USER_PROMPT
  }
}, {
  promptId: promptDictionary.attackDiscoveryDefault,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_DEFAULT
  }
}, {
  promptId: promptDictionary.attackDiscoveryRefine,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_REFINE
  }
}, {
  promptId: promptDictionary.attackDiscoveryContinue,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_CONTINUE
  }
}, {
  promptId: promptDictionary.attackDiscoveryDetailsMarkdown,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_DETAILS_MARKDOWN
  }
}, {
  promptId: promptDictionary.attackDiscoveryEntitySummaryMarkdown,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_ENTITY_SUMMARY_MARKDOWN
  }
}, {
  promptId: promptDictionary.attackDiscoveryMitreAttackTactics,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_MITRE_ATTACK_TACTICS
  }
}, {
  promptId: promptDictionary.attackDiscoverySummaryMarkdown,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_SUMMARY_MARKDOWN
  }
}, {
  promptId: promptDictionary.attackDiscoveryGenerationTitle,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_TITLE
  }
}, {
  promptId: promptDictionary.attackDiscoveryGenerationInsights,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_INSIGHTS
  }
}, {
  promptId: promptDictionary.chatTitle,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.DEFAULT_CHAT_TITLE
  }
}, {
  promptId: promptDictionary.chatTitle,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'bedrock',
  prompt: {
    default: _prompts.BEDROCK_CHAT_TITLE
  }
}, {
  promptId: promptDictionary.chatTitle,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'gemini',
  prompt: {
    default: _prompts.GEMINI_CHAT_TITLE
  }
}];