"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelOrOss = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * use oss as model when using openai and oss
 * else default to given model
 * if no model exists, let undefined and resolveProviderAndModel logic will determine the model from connector
 * @param llmType
 * @param isOssModel
 * @param model
 */
const getModelOrOss = (llmType, isOssModel, model) => llmType === 'openai' && isOssModel ? 'oss' : model;
exports.getModelOrOss = getModelOrOss;