"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.respond = respond;
var _run_agent = require("./run_agent");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function respond({
  config,
  logger,
  state,
  model
}) {
  logger.debug(() => `${_constants.NodeType.RESPOND}: Node state:\n${JSON.stringify(state, null, 2)}`);
  if (state !== null && state !== void 0 && state.agentOutcome && 'returnValues' in state.agentOutcome) {
    var _state$agentOutcome, _state$agentOutcome$r;
    const userMessage = ['user', `Respond exactly with
    ${(_state$agentOutcome = state.agentOutcome) === null || _state$agentOutcome === void 0 ? void 0 : (_state$agentOutcome$r = _state$agentOutcome.returnValues) === null || _state$agentOutcome$r === void 0 ? void 0 : _state$agentOutcome$r.output}

    Do not verify, confirm or anything else. Just reply with the same content as provided above.`];
    const responseMessage = await model
    // use AGENT_NODE_TAG to identify as agent node for stream parsing
    .withConfig({
      runName: 'Summarizer',
      tags: [_run_agent.AGENT_NODE_TAG],
      signal: config === null || config === void 0 ? void 0 : config.signal
    }).invoke([userMessage]);
    return {
      agentOutcome: {
        ...state.agentOutcome,
        returnValues: {
          output: responseMessage.content
        }
      },
      lastNode: _constants.NodeType.RESPOND
    };
  }
  return {
    lastNode: _constants.NodeType.RESPOND
  };
}