"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformESSearchToAttackDiscovery = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformESSearchToAttackDiscovery = response => {
  return response.hits.hits.filter(hit => hit._source !== undefined).map(hit => {
    var _adSchema$users$map, _adSchema$users, _adSchema$replacement, _adSchema$generation_, _adSchema$generation_2, _adSchema$average_int;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const adSchema = hit._source;
    const ad = {
      timestamp: adSchema['@timestamp'],
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: hit._id,
      backingIndex: hit._index,
      createdAt: adSchema.created_at,
      updatedAt: adSchema.updated_at,
      lastViewedAt: adSchema.last_viewed_at,
      users: (_adSchema$users$map = (_adSchema$users = adSchema.users) === null || _adSchema$users === void 0 ? void 0 : _adSchema$users.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _adSchema$users$map !== void 0 ? _adSchema$users$map : [],
      namespace: adSchema.namespace,
      status: adSchema.status,
      alertsContextCount: adSchema.alerts_context_count,
      apiConfig: {
        connectorId: adSchema.api_config.connector_id,
        actionTypeId: adSchema.api_config.action_type_id,
        defaultSystemPromptId: adSchema.api_config.default_system_prompt_id,
        model: adSchema.api_config.model,
        provider: adSchema.api_config.provider
      },
      attackDiscoveries: adSchema.attack_discoveries.map(attackDiscovery => ({
        alertIds: attackDiscovery.alert_ids,
        title: attackDiscovery.title,
        detailsMarkdown: attackDiscovery.details_markdown,
        entitySummaryMarkdown: attackDiscovery.entity_summary_markdown,
        mitreAttackTactics: attackDiscovery.mitre_attack_tactics,
        summaryMarkdown: attackDiscovery.summary_markdown,
        timestamp: attackDiscovery.timestamp
      })),
      replacements: (_adSchema$replacement = adSchema.replacements) === null || _adSchema$replacement === void 0 ? void 0 : _adSchema$replacement.reduce((acc, r) => {
        acc[r.uuid] = r.value;
        return acc;
      }, {}),
      generationIntervals: (_adSchema$generation_ = (_adSchema$generation_2 = adSchema.generation_intervals) === null || _adSchema$generation_2 === void 0 ? void 0 : _adSchema$generation_2.map(interval => ({
        date: interval.date,
        durationMs: interval.duration_ms
      }))) !== null && _adSchema$generation_ !== void 0 ? _adSchema$generation_ : [],
      averageIntervalMs: (_adSchema$average_int = adSchema.average_interval_ms) !== null && _adSchema$average_int !== void 0 ? _adSchema$average_int : 0,
      failureReason: adSchema.failure_reason
    };
    return ad;
  });
};
exports.transformESSearchToAttackDiscovery = transformESSearchToAttackDiscovery;