"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _find_all_attack_discoveries = require("./find_all_attack_discoveries/find_all_attack_discoveries");
var _find_attack_discovery_by_connector_id = require("./find_attack_discovery_by_connector_id/find_attack_discovery_by_connector_id");
var _update_attack_discovery = require("./update_attack_discovery/update_attack_discovery");
var _create_attack_discovery = require("./create_attack_discovery/create_attack_discovery");
var _get_attack_discovery = require("./get_attack_discovery/get_attack_discovery");
var _ai_assistant_data_clients = require("../../../ai_assistant_data_clients");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AttackDiscoveryDataClient extends _ai_assistant_data_clients.AIAssistantDataClient {
  constructor(options) {
    super(options);
    /**
     * Fetches an attack discovery
     * @param options
     * @param options.id The existing attack discovery id.
     * @param options.authenticatedUser Current authenticated user.
     * @returns The attack discovery response
     */
    (0, _defineProperty2.default)(this, "getAttackDiscovery", async ({
      id,
      authenticatedUser
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      return (0, _get_attack_discovery.getAttackDiscovery)({
        esClient,
        logger: this.options.logger,
        attackDiscoveryIndex: this.indexTemplateAndPattern.alias,
        id,
        user: authenticatedUser
      });
    });
    /**
     * Creates an attack discovery, if given at least the "apiConfig"
     * @param options
     * @param options.attackDiscoveryCreate
     * @param options.authenticatedUser
     * @returns The Attack Discovery created
     */
    (0, _defineProperty2.default)(this, "createAttackDiscovery", async ({
      attackDiscoveryCreate,
      authenticatedUser
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      return (0, _create_attack_discovery.createAttackDiscovery)({
        esClient,
        logger: this.options.logger,
        attackDiscoveryIndex: this.indexTemplateAndPattern.alias,
        spaceId: this.spaceId,
        user: authenticatedUser,
        attackDiscoveryCreate
      });
    });
    /**
     * Find attack discovery by apiConfig connectorId
     * @param options
     * @param options.connectorId
     * @param options.authenticatedUser
     * @returns The Attack Discovery found
     */
    (0, _defineProperty2.default)(this, "findAttackDiscoveryByConnectorId", async ({
      connectorId,
      authenticatedUser
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      return (0, _find_attack_discovery_by_connector_id.findAttackDiscoveryByConnectorId)({
        esClient,
        logger: this.options.logger,
        attackDiscoveryIndex: this.indexTemplateAndPattern.alias,
        connectorId,
        user: authenticatedUser
      });
    });
    /**
     * Finds all attack discovery for authenticated user
     * @param options
     * @param options.authenticatedUser
     * @returns The Attack Discovery
     */
    (0, _defineProperty2.default)(this, "findAllAttackDiscoveries", async ({
      authenticatedUser
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      return (0, _find_all_attack_discoveries.findAllAttackDiscoveries)({
        esClient,
        logger: this.options.logger,
        attackDiscoveryIndex: this.indexTemplateAndPattern.alias,
        user: authenticatedUser
      });
    });
    /**
     * Updates an attack discovery
     * @param options
     * @param options.attackDiscoveryUpdateProps
     * @param options.authenticatedUser
     */
    (0, _defineProperty2.default)(this, "updateAttackDiscovery", async ({
      attackDiscoveryUpdateProps,
      authenticatedUser
    }) => {
      const esClient = await this.options.elasticsearchClientPromise;
      return (0, _update_attack_discovery.updateAttackDiscovery)({
        esClient,
        logger: this.options.logger,
        attackDiscoveryIndex: attackDiscoveryUpdateProps.backingIndex,
        attackDiscoveryUpdateProps,
        user: authenticatedUser
      });
    });
    this.options = options;
  }
}
exports.AttackDiscoveryDataClient = AttackDiscoveryDataClient;