"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRefineOrEndEdge = void 0;
var _get_refine_or_end_decision = require("./helpers/get_refine_or_end_decision");
var _get_has_results = require("../helpers/get_has_results");
var _get_max_hallucination_failures_reached = require("../../helpers/get_max_hallucination_failures_reached");
var _get_max_retries_reached = require("../../helpers/get_max_retries_reached");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRefineOrEndEdge = logger => {
  const edge = state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---REFINE OR END---');
    const {
      attackDiscoveries,
      generationAttempts,
      hallucinationFailures,
      maxGenerationAttempts,
      maxHallucinationFailures
    } = state;
    const hasFinalResults = (0, _get_has_results.getHasResults)(attackDiscoveries);
    const maxRetriesReached = (0, _get_max_retries_reached.getMaxRetriesReached)({
      generationAttempts,
      maxGenerationAttempts
    });
    const maxHallucinationFailuresReached = (0, _get_max_hallucination_failures_reached.getMaxHallucinationFailuresReached)({
      hallucinationFailures,
      maxHallucinationFailures
    });
    const decision = (0, _get_refine_or_end_decision.getRefineOrEndDecision)({
      hasFinalResults,
      maxHallucinationFailuresReached,
      maxRetriesReached
    });
    logger === null || logger === void 0 ? void 0 : logger.debug(() => {
      var _attackDiscoveries$le;
      return `refineOrEndEdge evaluated the following (derived) state:\n${JSON.stringify({
        attackDiscoveries: (_attackDiscoveries$le = attackDiscoveries === null || attackDiscoveries === void 0 ? void 0 : attackDiscoveries.length) !== null && _attackDiscoveries$le !== void 0 ? _attackDiscoveries$le : 0,
        generationAttempts,
        hallucinationFailures,
        hasFinalResults,
        maxHallucinationFailuresReached,
        maxRetriesReached
      }, null, 2)}
        \n---REFINE OR END: ${decision}---`;
    });
    return decision;
  };
  return edge;
};
exports.getRefineOrEndEdge = getRefineOrEndEdge;