"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefendInsightsGetResponse = exports.DefendInsightsGetRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../common_attributes.gen");
var _common_attributes2 = require("./common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Get Defend Insights API endpoint
 *   version: 1
 */

const DefendInsightsGetRequestQuery = exports.DefendInsightsGetRequestQuery = _zod.z.object({
  /**
   * The insight ids for which to get Defend insights
   */
  ids: (0, _zodHelpers.ArrayFromString)(_common_attributes.NonEmptyString).optional(),
  /**
   * The connector id for which to get Defend insights
   */
  connector_id: _common_attributes.NonEmptyString.optional(),
  /**
   * The insight type for which to get Defend insights
   */
  type: _common_attributes2.DefendInsightType.optional(),
  /**
   * The status for which to get Defend insights
   */
  status: _common_attributes2.DefendInsightStatus.optional(),
  /**
   * The endpoint ids for which to get Defend insights
   */
  endpoint_ids: (0, _zodHelpers.ArrayFromString)(_common_attributes.NonEmptyString).optional(),
  /**
   * The number of Defend insights to return
   */
  size: _zod.z.coerce.number().optional()
});
const DefendInsightsGetResponse = exports.DefendInsightsGetResponse = _zod.z.object({
  data: _zod.z.array(_common_attributes2.DefendInsightsResponse)
});