"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizedValue = void 0;
var _fp = require("lodash/fp");
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnonymizedValue = ({
  currentReplacements,
  rawValue
}) => {
  if (currentReplacements != null) {
    const rawValueToReplacement = (0, _fp.invert)(currentReplacements);
    const existingReplacement = rawValueToReplacement[rawValue];
    return existingReplacement != null ? existingReplacement : (0, _uuid.v4)();
  }
  return (0, _uuid.v4)();
};
exports.getAnonymizedValue = getAnonymizedValue;