"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ELASTIC_AI_ASSISTANT_URL = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_INDICES_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_FIND = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_EVALUATE_URL = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID_MESSAGES = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_CHAT_COMPLETE_URL = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL = exports.DEFEND_INSIGHTS_TOOL_ID = exports.DEFEND_INSIGHTS_BY_ID = exports.DEFEND_INSIGHTS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ELASTIC_AI_ASSISTANT_URL = exports.ELASTIC_AI_ASSISTANT_URL = '/api/security_ai_assistant';
const ELASTIC_AI_ASSISTANT_INTERNAL_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_URL = '/internal/elastic_assistant';
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL = `${ELASTIC_AI_ASSISTANT_URL}/current_user/conversations`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID = `${ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL}/{id}`;
const ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/current_user/conversations`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID_MESSAGES = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID_MESSAGES = `${ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL}/{id}/messages`;
const ELASTIC_AI_ASSISTANT_CHAT_COMPLETE_URL = exports.ELASTIC_AI_ASSISTANT_CHAT_COMPLETE_URL = `${ELASTIC_AI_ASSISTANT_URL}/chat/complete`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_FIND = `${ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL}/_find`;
const ELASTIC_AI_ASSISTANT_PROMPTS_URL = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL = `${ELASTIC_AI_ASSISTANT_URL}/prompts`;
const ELASTIC_AI_ASSISTANT_PROMPTS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_PROMPTS_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_PROMPTS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_FIND = `${ELASTIC_AI_ASSISTANT_PROMPTS_URL}/_find`;
const ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL = `${ELASTIC_AI_ASSISTANT_URL}/anonymization_fields`;
const ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_FIND = `${ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL}/_find`;

// TODO: Update existing 'status' endpoint to take resource as query param as to not conflict with 'entries'
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_URL = `${ELASTIC_AI_ASSISTANT_URL}/knowledge_base/{resource?}`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL = `${ELASTIC_AI_ASSISTANT_URL}/knowledge_base/entries`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID = `${ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL}/{id}`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_FIND = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_FIND = `${ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL}/_find`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_INDICES_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_INDICES_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/knowledge_base/_indices`;
const ELASTIC_AI_ASSISTANT_EVALUATE_URL = exports.ELASTIC_AI_ASSISTANT_EVALUATE_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/evaluate`;

// Defend insights
const DEFEND_INSIGHTS_TOOL_ID = exports.DEFEND_INSIGHTS_TOOL_ID = 'defend-insights';
const DEFEND_INSIGHTS = exports.DEFEND_INSIGHTS = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/defend_insights`;
const DEFEND_INSIGHTS_BY_ID = exports.DEFEND_INSIGHTS_BY_ID = `${DEFEND_INSIGHTS}/{id}`;