"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSdkNameAndLanguage = void 0;
var _agent_guards = require("./agent_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LANGUAGE_INDEX = 1;
const getSdkNameAndLanguage = agentName => {
  if ((0, _agent_guards.isElasticAgentName)(agentName)) {
    return {
      sdkName: 'apm',
      language: agentName
    };
  }
  const agentNameParts = agentName.split('/');
  if ((0, _agent_guards.isOpenTelemetryAgentName)(agentName)) {
    if (agentNameParts[agentNameParts.length - 1] === 'elastic') {
      return {
        sdkName: 'edot',
        language: agentNameParts[LANGUAGE_INDEX]
      };
    }
    return {
      sdkName: 'otel_other',
      language: agentNameParts[LANGUAGE_INDEX]
    };
  }
  return {
    sdkName: undefined,
    language: undefined
  };
};
exports.getSdkNameAndLanguage = getSdkNameAndLanguage;