"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER_ID = exports.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER = exports.EDITABLE_SAVED_SEARCH_KEYS = exports.EDITABLE_PANEL_KEYS = exports.DEFAULT_HEADER_ROW_HEIGHT_LINES = void 0;
Object.defineProperty(exports, "SEARCH_EMBEDDABLE_TYPE", {
  enumerable: true,
  get: function () {
    return _discoverUtils.SEARCH_EMBEDDABLE_TYPE;
  }
});
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER_ID = exports.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER_ID = 'SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER_ID';
const SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER = exports.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER = {
  id: SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER_ID,
  title: 'Discover session embeddable cell actions',
  description: 'This trigger is used to replace the cell actions for Discover session embeddable grid.'
};
const DEFAULT_HEADER_ROW_HEIGHT_LINES = exports.DEFAULT_HEADER_ROW_HEIGHT_LINES = 3;

/** This constant refers to the parts of the saved search state that can be edited from a dashboard */
const EDITABLE_SAVED_SEARCH_KEYS = exports.EDITABLE_SAVED_SEARCH_KEYS = ['sort', 'columns', 'rowHeight', 'sampleSize', 'rowsPerPage', 'headerRowHeight', 'density', 'grid'];

/** This constant refers to the dashboard panel specific state */
const EDITABLE_PANEL_KEYS = exports.EDITABLE_PANEL_KEYS = ['title',
// panel title
'description',
// panel description
'timeRange',
// panel custom time range
'hidePanelTitles',
// panel hidden title
'enhancements' // panel enhancements (e.g. drilldowns)
];