"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsDataSourceProfileProvider = void 0;
var _profiles = require("../../../profiles");
var _accessors = require("./accessors");
var _extract_index_pattern_from = require("../../extract_index_pattern_from");
var _consts = require("../consts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createLogsDataSourceProfileProvider = services => ({
  profileId: 'observability-logs-data-source-profile',
  profile: {
    getDefaultAppState: (0, _accessors.createGetDefaultAppState)(),
    getCellRenderers: _accessors.getCellRenderers,
    getRowIndicatorProvider: _accessors.getRowIndicatorProvider,
    getRowAdditionalLeadingControls: _accessors.getRowAdditionalLeadingControls
  },
  resolve: params => {
    if (params.rootContext.profileId !== _consts.OBSERVABILITY_ROOT_PROFILE_ID) {
      return {
        isMatch: false
      };
    }
    const indexPattern = (0, _extract_index_pattern_from.extractIndexPatternFrom)(params);
    if (!services.logsContextService.isLogsIndexPattern(indexPattern)) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Logs
      }
    };
  }
});
exports.createLogsDataSourceProfileProvider = createLogsDataSourceProfileProvider;