"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfileAccessor = void 0;
var _react = require("react");
var _composable_profile = require("../composable_profile");
var _use_profiles = require("./use_profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook to retrieve an extension point accessor based on the resolved profiles
 * @param key The key of the extension point
 * @param options Options to get the resolved profiles
 * @returns The resolved accessor function
 */
const useProfileAccessor = (key, options = {}) => {
  const profiles = (0, _use_profiles.useProfiles)(options);
  return (0, _react.useCallback)(baseImpl => (0, _composable_profile.getMergedAccessor)(profiles, key, baseImpl), [key, profiles]);
};
exports.useProfileAccessor = useProfileAccessor;