"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverHistogramLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-histogram-plugin/public");
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_discover_histogram = require("./use_discover_histogram");
var _discover_main_content = require("./discover_main_content");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const histogramLayoutCss = (0, _react2.css)`
  height: 100%;
`;
const DiscoverHistogramLayout = ({
  dataView,
  stateContainer,
  container,
  panelsToggle,
  ...mainContentProps
}) => {
  const {
    dataState
  } = stateContainer;
  const searchSessionId = (0, _useObservable.default)(stateContainer.searchSessionManager.searchSessionId$);
  const hideChart = (0, _discover_app_state_container.useAppStateSelector)(state => state.hideChart);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const unifiedHistogramProps = (0, _use_discover_histogram.useDiscoverHistogram)({
    stateContainer,
    inspectorAdapters: dataState.inspectorAdapters,
    hideChart
  });
  const renderCustomChartToggleActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.isValidElement(panelsToggle) ? /*#__PURE__*/_react.default.cloneElement(panelsToggle, {
    renderedFor: 'histogram'
  }) : panelsToggle, [panelsToggle]);

  // Initialized when the first search has been requested or
  // when in ES|QL mode since search sessions are not supported
  if (!searchSessionId && !isEsqlMode) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.UnifiedHistogramContainer, (0, _extends2.default)({}, unifiedHistogramProps, {
    searchSessionId: searchSessionId,
    requestAdapter: dataState.inspectorAdapters.requests,
    container: container,
    css: histogramLayoutCss,
    renderCustomChartToggleActions: renderCustomChartToggleActions,
    abortController: stateContainer.dataState.getAbortController()
  }), /*#__PURE__*/_react.default.createElement(_discover_main_content.DiscoverMainContent, (0, _extends2.default)({}, mainContentProps, {
    stateContainer: stateContainer,
    dataView: dataView,
    panelsToggle: panelsToggle
  })));
};
exports.DiscoverHistogramLayout = DiscoverHistogramLayout;