"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextErrorMessage = ContextErrorMessage;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _context_query_state = require("../../services/context_query_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ContextErrorMessage({
  status
}) {
  if (status.value !== _context_query_state.LoadingStatus.FAILED) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.context.failedToLoadAnchorDocumentDescription",
      defaultMessage: "Failed to load the anchor document"
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "contextErrorMessageTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "contextErrorMessageBody"
  }, status.reason === _context_query_state.FailureReason.UNKNOWN && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.context.reloadPageDescription.reloadOrVisitTextMessage",
    defaultMessage: "Please reload or go back to the document list to select a valid anchor document."
  })));
}