"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reduceAsyncChunks = void 0;
var _rxjs = require("rxjs");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_HTTP_LINE_LENGTH = 4096;
// Apply an 80% threshold to the http line max length to guarantee enough space for url and potentially other parameters.
// This value might need to vary as it's an estimate of how much we can reserve for the chunked list length.
const MAX_CHUNK_LENGTH = MAX_HTTP_LINE_LENGTH * 0.75; // 4096 *0.75 === 3072 characters, as 1 chars = 1 byte

const reduceAsyncChunks = (list, chunkExecutor) => {
  const result$ = (0, _rxjs.from)(list).pipe(bufferUntil(isLessThanMaxChunkLength), (0, _rxjs.mergeMap)((chunk, id) => (0, _rxjs.from)(chunkExecutor(chunk, id))), (0, _rxjs.reduce)((result, chunkResult) => (0, _deepmerge.default)(result, chunkResult)));
  return (0, _rxjs.lastValueFrom)(result$);
};

/**
 * Support functions for reduceAsyncChunks
 */
exports.reduceAsyncChunks = reduceAsyncChunks;
const bufferUntil = predicate => {
  return source => new _rxjs.Observable(observer => {
    let chunk = [];
    return source.subscribe({
      next(currentItem) {
        if (predicate(chunk, currentItem)) {
          chunk.push(currentItem);
        } else {
          // Emit the current chunk, start a new one
          if (chunk.length > 0) observer.next(chunk);
          chunk = [currentItem]; // Reset the chunk with the current item
        }
      },
      complete() {
        // Emit the final chunk if it has any items
        if (chunk.length > 0) observer.next(chunk);
        observer.complete();
      }
    });
  });
};
const isLessThanMaxChunkLength = (chunk, currentItem) => {
  const totalLength = [...chunk, currentItem].join().length;
  return totalLength <= MAX_CHUNK_LENGTH; // Allow the chunk until it exceeds the max chunk length
};