"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamService = void 0;
var _reduce_async_chunks = require("../utils/reduce_async_chunks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamService {
  async getMatchingDataStreams(esClient, datasetName) {
    try {
      const {
        data_streams: dataStreamsInfo
      } = await esClient.indices.getDataStream({
        name: datasetName,
        verbose: true
      });
      return dataStreamsInfo;
    } catch (e) {
      if (e.statusCode === 404) {
        return [];
      }
      throw e;
    }
  }
  async getStreamsStats(esClient, dataStreams) {
    try {
      const {
        data_streams: dataStreamsStats
      } = await (0, _reduce_async_chunks.reduceAsyncChunks)(dataStreams, dataStreamsChunk => esClient.indices.dataStreamsStats({
        name: dataStreamsChunk.join(','),
        human: true
      }));
      return dataStreamsStats;
    } catch (e) {
      if (e.statusCode === 404) {
        return [];
      }
      throw e;
    }
  }
  async getDataStreamIndexSettings(esClient, dataStream) {
    try {
      const settings = await esClient.indices.getSettings({
        index: dataStream
      });
      return settings;
    } catch (e) {
      if (e.statusCode === 404) {
        return {};
      }
      throw e;
    }
  }
}
const dataStreamService = exports.dataStreamService = new DataStreamService();