"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.failedDocsRouteRepository = void 0;
var _boom = require("@hapi/boom");
var t = _interopRequireWildcard(require("io-ts"));
var _default_api_types = require("../../../types/default_api_types");
var _create_datasets_quality_server_route = require("../../create_datasets_quality_server_route");
var _get_failed_docs = require("./get_failed_docs");
var _get_failed_docs_details = require("./get_failed_docs_details");
var _get_failed_docs_errors = require("./get_failed_docs_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const failedDocsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/failed_docs',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, t.type({
      types: _default_api_types.typesRt
    }), t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  security: {
    authz: {
      enabled: false,
      reason: 'This API delegates security to the currently logged in user and their Elasticsearch permissions.'
    }
  },
  async handler(resources) {
    const {
      context,
      params,
      logger,
      getEsCapabilities
    } = resources;
    const coreContext = await context.core;
    const isServerless = (await getEsCapabilities()).serverless;
    if (isServerless) {
      throw (0, _boom.notImplemented)('Failure store is not available in serverless mode');
    }
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    try {
      const failedDocs = await (0, _get_failed_docs.getFailedDocsPaginated)({
        esClient,
        ...params.query
      });
      return {
        failedDocs
      };
    } catch (e) {
      logger.error(`Failed to get failed docs: ${e}`);
      return {
        failedDocs: []
      };
    }
  }
});
const failedDocsDetailsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/failed_docs',
  params: t.type({
    path: t.type({
      dataStream: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: []
  },
  security: {
    authz: {
      enabled: false,
      reason: 'This API delegates security to the currently logged in user and their Elasticsearch permissions.'
    }
  },
  async handler(resources) {
    const {
      context,
      params,
      getEsCapabilities
    } = resources;
    const coreContext = await context.core;
    const {
      dataStream
    } = params.path;
    const isServerless = (await getEsCapabilities()).serverless;
    if (isServerless) {
      throw (0, _boom.notImplemented)('Failure store is not available in serverless mode');
    }
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    return await (0, _get_failed_docs_details.getFailedDocsDetails)({
      esClient,
      dataStream,
      ...params.query
    });
  }
});
const failedDocsErrorsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/failed_docs/errors',
  params: t.type({
    path: t.type({
      dataStream: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: []
  },
  security: {
    authz: {
      enabled: false,
      reason: 'This API delegates security to the currently logged in user and their Elasticsearch permissions.'
    }
  },
  async handler(resources) {
    const {
      context,
      params,
      getEsCapabilities
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const isServerless = (await getEsCapabilities()).serverless;
    if (isServerless) {
      throw (0, _boom.notImplemented)('Failure store is not available in serverless mode');
    }
    return await (0, _get_failed_docs_errors.getFailedDocsErrors)({
      esClient,
      dataStream: params.path.dataStream,
      ...params.query
    });
  }
});
const failedDocsRouteRepository = exports.failedDocsRouteRepository = {
  ...failedDocsRoute,
  ...failedDocsDetailsRoute,
  ...failedDocsErrorsRoute
};